<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Libraries\Utils;
use App\Settings;
use Input;
use Session;
use StdClass;

class SettingsController extends Controller
{

    public function all()
    {
        $settings = [];

        //Custom CSS Tab
        $settings_custom_css = new StdClass();
        $settings_custom_css->custom_css = Settings::where('category', Settings::CATEGORY_CUSTOM_CSS)->where('column_key', Settings::CATEGORY_CUSTOM_CSS)->first();
        $settings['custom_css'] = $settings_custom_css;

        //Custom CSS Tab
        $settings_custom_js = new StdClass();
        $settings_custom_js->custom_js = Settings::where('category', Settings::CATEGORY_CUSTOM_JS)->where('column_key', Settings::CATEGORY_CUSTOM_JS)->first();
        $settings['custom_js'] = $settings_custom_js;

        //Social Tab
        $settings_social = new StdClass();
        $settings_social->fb_page_url = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'fb_page_url')->first();
        $settings_social->twitter_handle = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_handle')->first();
        $settings_social->twitter_url = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_url')->first();
        $settings_social->google_plus_page_url = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'google_plus_page_url')->first();
        $settings_social->skype_username = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'skype_username')->first();
        $settings_social->youtube_channel_url = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'youtube_channel_url')->first();
        $settings_social->vimeo_channel_url = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'vimeo_channel_url')->first();
        $settings_social->addthis_js = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'addthis_js')->first();
        $settings_social->sharethis_js = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'sharethis_js')->first();
        $settings_social->sharethis_span_tags = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'sharethis_span_tags')->first();
        $settings_social->facebook_box_js = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'facebook_box_js')->first();
        $settings_social->twitter_box_js = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_box_js')->first();
        $settings_social->show_sharing = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'show_sharing')->first();

        $settings['social'] = $settings_social;

        //Comments Tab
        $settings_comments = new StdClass();
        $settings_comments->comment_system = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'comment_system')->first();
        $settings_comments->fb_js = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_js')->first();
        $settings_comments->fb_num_posts = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_num_posts')->first();
        $settings_comments->fb_comment_count = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_comment_count')->first();
        $settings_comments->disqus_js = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'disqus_js')->first();
        $settings_comments->disqus_comment_count = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'disqus_comment_count')->first();
        $settings_comments->show_comment_box = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'show_comment_box')->first();

        $settings['comments'] = $settings_comments;

        //SEO Tab
        $settings_seo = new StdClass();
        $settings_seo->seo_keywords = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'seo_keywords')->first();
        $settings_seo->seo_description = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'seo_description')->first();
        $settings_seo->google_verify = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'google_verify')->first();
        $settings_seo->bing_verify = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'bing_verify')->first();

        $settings['seo'] = $settings_seo;

        //General Tab
        $settings_general = new StdClass();
        $settings_general->site_url = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_url')->first();
        $settings_general->site_title = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_title')->first();
        $settings_general->analytics_code = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'analytics_code')->first();
        $settings_general->mailchimp_form = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'mailchimp_form')->first();
        $settings_general->logo_76 = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_76')->first();
        $settings_general->logo_120 = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_120')->first();
        $settings_general->logo_152 = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_152')->first();
        $settings_general->favicon = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'favicon')->first();
        $settings_general->site_post_as_titles = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_post_as_titles')->first();
        $settings_general->generate_sitemap = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'generate_sitemap')->first();
        $settings_general->generate_rss_feeds = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'generate_rss_feeds')->first();
        $settings_general->include_sources = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'include_sources')->first();

        $settings['general'] = $settings_general;

        return view('admin.settings.all', compact('settings'));
    }

    public function updateCustomCSS()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_CUSTOM_CSS)->where('column_key', Settings::CATEGORY_CUSTOM_CSS)->get()) > 0) {
            Settings::where('category', Settings::CATEGORY_CUSTOM_CSS)->where('column_key', Settings::CATEGORY_CUSTOM_CSS)->update(['value_txt' => Input::get('custom_css')]);
        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_CUSTOM_CSS;
            $settings->column_key = Settings::CATEGORY_CUSTOM_CSS;
            $settings->value_txt = Input::get('custom_css');
            $settings->save();
        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }

    public function updateCustomJS()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_CUSTOM_JS)->where('column_key', Settings::CATEGORY_CUSTOM_JS)->get()) > 0) {
            Settings::where('category', Settings::CATEGORY_CUSTOM_JS)->where('column_key', Settings::CATEGORY_CUSTOM_JS)->update(['value_txt' => Input::get('custom_js')]);
        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_CUSTOM_JS;
            $settings->column_key = Settings::CATEGORY_CUSTOM_JS;
            $settings->value_txt = Input::get('custom_js');
            $settings->save();
        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }

    public function updateSocial()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_SOCIAL)->get()) > 0) {

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'fb_page_url')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'fb_page_url';
            $settings->value_string = Input::get('fb_page_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_url')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'twitter_url';
            $settings->value_string = Input::get('twitter_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_handle')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'twitter_handle';
            $settings->value_string = Input::get('twitter_handle');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'google_plus_page_url')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'google_plus_page_url';
            $settings->value_string = Input::get('google_plus_page_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'skype_username')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'skype_username';
            $settings->value_string = Input::get('skype_username');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'youtube_channel_url')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'youtube_channel_url';
            $settings->value_string = Input::get('youtube_channel_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'vimeo_channel_url')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'vimeo_channel_url';
            $settings->value_string = Input::get('vimeo_channel_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'addthis_js')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'addthis_js';
            $settings->value_txt = Input::get('addthis_js');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'sharethis_js')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'sharethis_js';
            $settings->value_txt = Input::get('sharethis_js');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'sharethis_span_tags')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'sharethis_span_tags';
            $settings->value_txt = Input::get('sharethis_span_tags');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'facebook_box_js')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'facebook_box_js';
            $settings->value_txt = Input::get('facebook_box_js');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'twitter_box_js')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'twitter_box_js';
            $settings->value_txt = Input::get('twitter_box_js');
            $settings->save();


            $settings = Settings::where('category', Settings::CATEGORY_SOCIAL)->where('column_key', 'show_sharing')->first();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'show_sharing';
            $settings->value_check = Input::has('show_sharing') ? 1 : 0;
            $settings->save();

        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'fb_page_url';
            $settings->value_string = Input::get('fb_page_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'twitter_url';
            $settings->value_string = Input::get('twitter_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'google_plus_page_url';
            $settings->value_string = Input::get('google_plus_page_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'skype_username';
            $settings->value_string = Input::get('skype_username');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'youtube_channel_url';
            $settings->value_string = Input::get('youtube_channel_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'vimeo_channel_url';
            $settings->value_string = Input::get('vimeo_channel_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'addthis_js';
            $settings->value_txt = Input::get('addthis_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'sharethis_js';
            $settings->value_txt = Input::get('sharethis_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'sharethis_span_tags';
            $settings->value_txt = Input::get('sharethis_span_tags');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'facebook_box_js';
            $settings->value_txt = Input::get('facebook_box_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'twitter_box_js';
            $settings->value_txt = Input::get('twitter_box_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SOCIAL;
            $settings->column_key = 'show_sharing';
            $settings->value_check = Input::has('show_sharing') ? 1 : 0;
            $settings->save();

        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }

    public function updateComments()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_COMMENTS)->get()) > 0) {

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'comment_system')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'comment_system';
            $settings->value_string = Input::get('comment_system');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_js')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_js';
            $settings->value_txt = Input::get('fb_js');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_num_posts')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_num_posts';
            $settings->value_string = Input::get('fb_num_posts');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'fb_comment_count')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_comment_count';
            $settings->value_check = Input::has('fb_comment_count') ? 1 : 0;
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'disqus_js')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'disqus_js';
            $settings->value_txt = Input::get('disqus_js');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'disqus_comment_count')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'disqus_comment_count';
            $settings->value_check = Input::has('disqus_comment_count') ? 1 : 0;
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_COMMENTS)->where('column_key', 'show_comment_box')->first();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'show_comment_box';
            $settings->value_check = Input::has('show_comment_box') ? 1 : 0;
            $settings->save();

        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'comment_system';
            $settings->value_string = Input::get('comment_system');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_js';
            $settings->value_txt = Input::get('fb_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_num_posts';
            $settings->value_string = Input::get('fb_num_posts');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'fb_comment_count';
            $settings->value_check = Input::get('fb_comment_count');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'disqus_js';
            $settings->value_txt = Input::get('disqus_js');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'disqus_comment_count';
            $settings->value_check = Input::get('disqus_comment_count');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_COMMENTS;
            $settings->column_key = 'show_comment_box';
            $settings->value_check = Input::has('show_comment_box') ? 1 : 0;
            $settings->save();

        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }

    public function updateSEO()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_SEO)->get()) > 0) {

            $settings = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'seo_keywords')->first();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'seo_keywords';
            $settings->value_txt = Input::get('seo_keywords');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'seo_description')->first();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'seo_description';
            $settings->value_txt = Input::get('seo_description');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'google_verify')->first();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'google_verify';
            $settings->value_string = Input::get('google_verify');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_SEO)->where('column_key', 'bing_verify')->first();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'bing_verify';
            $settings->value_string = Input::get('bing_verify');
            $settings->save();


        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'seo_keywords';
            $settings->value_txt = Input::get('seo_keywords');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'seo_description';
            $settings->value_txt = Input::get('seo_description');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'google_verify';
            $settings->value_string = Input::get('google_verify');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_SEO;
            $settings->column_key = 'bing_verify';
            $settings->value_string = Input::get('bing_verify');
            $settings->save();

        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }

    public function updateGeneral()
    {

        if (sizeof(Settings::where('category', Settings::CATEGORY_GENERAL)->get()) > 0) {

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_url')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_url';
            $settings->value_string = Input::get('site_url');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_title')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_title';
            $settings->value_string = Input::get('site_title');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'analytics_code')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'analytics_code';
            $settings->value_txt = Input::get('analytics_code');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'mailchimp_form')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'mailchimp_form';
            $settings->value_txt = Input::get('mailchimp_form');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_76')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_76';
            $settings->value_string = Input::hasFile('logo_76')?Utils::imageUpload(Input::file('logo_76'), 'images'):Input::get('logo_76_value');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_120')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_120';
            $settings->value_string = Input::hasFile('logo_120')?Utils::imageUpload(Input::file('logo_120'), 'images'):Input::get('logo_120_value');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'logo_152')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_152';
            $settings->value_string = Input::hasFile('logo_152')?Utils::imageUpload(Input::file('logo_152'), 'images'):Input::get('logo_152_value');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'favicon')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'favicon';
            $settings->value_string = Input::hasFile('favicon')?Utils::imageUpload(Input::file('favicon'), 'images'):Input::get('favicon_value');
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'site_post_as_titles')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_post_as_titles';
            $settings->value_check = Input::has('site_post_as_titles') ? 1:0;
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'generate_sitemap')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'generate_sitemap';
            $settings->value_check = Input::has('generate_sitemap') ? 1:0;
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'generate_rss_feeds')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'generate_rss_feeds';
            $settings->value_check = Input::has('generate_rss_feeds') ? 1:0;
            $settings->save();

            $settings = Settings::where('category', Settings::CATEGORY_GENERAL)->where('column_key', 'include_sources')->first();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'include_sources';
            $settings->value_check = Input::has('include_sources') ? 1:0;
            $settings->save();


        } else {
            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_url';
            $settings->value_string = Input::get('site_url');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_title';
            $settings->value_string = Input::get('site_title');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'analytics_code';
            $settings->value_txt = Input::get('analytics_code');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'mailchimp_form';
            $settings->value_txt = Input::get('mailchimp_form');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_76';
            $settings->value_string = Input::hasFile('logo_76')?Utils::imageUpload(Input::file('logo_76'), 'images'):Input::get('logo_76_value');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_120';
            $settings->value_string = Input::hasFile('logo_120')?Utils::imageUpload(Input::file('logo_120'), 'images'):Input::get('logo_120_value');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'logo_152';
            $settings->value_string = Input::hasFile('logo_152')?Utils::imageUpload(Input::file('logo_152'), 'images'):Input::get('logo_152_value');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'favicon';
            $settings->value_string = Input::hasFile('favicon')?Utils::imageUpload(Input::file('favicon'), 'images'):Input::get('favicon_value');
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'site_post_as_titles';
            $settings->value_check = Input::has('site_post_as_titles') ? 1:0;
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'generate_sitemap';
            $settings->value_check = Input::has('generate_sitemap') ? 1:0;
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'generate_rss_feeds';
            $settings->value_check = Input::has('generate_rss_feeds') ? 1:0;
            $settings->save();

            $settings = new Settings();
            $settings->category = Settings::CATEGORY_GENERAL;
            $settings->column_key = 'include_sources';
            $settings->value_check = Input::has('include_sources') ? 1:0;
            $settings->save();

        }

        Session::flash('success_msg', 'Settings updated successfully');
        return redirect()->to('/admin/settings');
    }
}